/*
template:https://github.com/Jonathan-Uy/CSES-Solutions/blob/main/Geometry/Convex%20Hull.cpp
*/

#include <bits/stdc++.h>

#define int long long

#define ll long long  

#define pb push_back
 
#define F first
 
#define S second
 
using namespace std;
 
const int N = 2e5 + 10;

const int mod = 1e9 + 7;

const int inf = 2e18;
 
struct Point {
    int x, y;
    Point operator +(const Point& b) const { return Point{x+b.x, y+b.y}; }
    Point operator -(const Point& b) const { return Point{x-b.x, y-b.y}; }
    ll operator *(const Point& b) const { return (ll) x * b.y - (ll) y * b.x; }
    bool operator <(const Point& b) const { return x == b.x ? y < b.y : x < b.x; }
    void operator +=(const Point& b) { x += b.x; y += b.y; }
    void operator -=(const Point &b) { x -= b.x; y -= b.y; }
    void operator *=(const int k) { x *= k; y *= k; }
	bool operator ==(const Point& b) const { return (x == b.x && y == b.y) ? 1 : 0; }

    ll cross(const Point& b, const Point& c) const {
        return (b - *this) * (c - *this);
    }
};

vector<Point> ch(vector<Point>a,bool ok,Point K) {
	sort(a.begin(),a.end());
	vector<Point>hull;
	int s = 0,n = a.size();
	for(int t = 0; t < 2; t++){
        for(int i = 0; i < n; i++){
        	if(ok && K == a[i]) continue;
            while((int) hull.size()-s >= 2){
                Point P1 = hull[hull.size()-2];
                Point P2 = hull[hull.size()-1];
                if(P1.cross(P2, a[i]) <= 0) break;
                hull.pop_back();
            }
            hull.push_back(a[i]);
        }
        hull.pop_back();
        s = hull.size();
        reverse(a.begin(),a.end());
    }
	return hull;
}

int Povrsina(vector<Point> a) {
    int P = 0;
    int n = a.size();
    for (int i = 0; i < n; i++) {
        P += a[i].x * a[(i + 1) % n].y - a[i].y * a[(i + 1) % n].x;
    }
    return P / 2;
}


signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

 	int n;
 	cin >> n;
 	vector<Point>a(n);
 	for(int i = 0; i < n; i++) {
 		int q,w;
 		cin >> q >> w;
		a[i].x = q;
		a[i].y = w;
 	}
 	int res = inf;
	if(n <= 2000) {
		for(int i = 0; i < n; i++) {
			vector<Point>v;
			for(int j = 0; j < n; j++) {
				if(i ^ j) v.pb(a[j]);
			}
			Point Y;
			vector<Point>h = ch(v,0,Y);
			res = min(res,abs(Povrsina(h)));
		}
		cout << res;
		return 0;
	}
	Point Y;
	vector<Point>hull = ch(a,0,Y);
	for(Point tacka : hull) {
		vector<Point>h = ch(a,1,tacka);
		res = min(res,abs(Povrsina(h)));
	}
	cout << res;
    return 0;
}